/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminWorkObjectTableData;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.util.Locale;
import java.util.Vector;

public final class VWAdminCommon {
    protected static boolean isAnyLockedByOthers(Vector wobsList) {
        try {
            for (int i = 0; i < wobsList.size(); ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)wobsList.elementAt(i);
                int lockedStatus = woData.getLockedStatus();
                switch (lockedStatus) {
                    case 0: {
                        return true;
                    }
                    case 2: {
                        return true;
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return false;
    }

    protected static VWAdminWorkObjectTableData findWoData(VWWorkObject wob, Vector wobsList) {
        try {
            String wobNum = wob.getWorkObjectNumber();
            for (int i = 0; i < wobsList.size(); ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)wobsList.elementAt(i);
                if (VWStringUtils.compare(wobNum, woData.getWob().getWorkObjectNumber()) != 0) continue;
                return woData;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected static boolean isAnyWorkModified(Vector wobsList) {
        try {
            for (int i = 0; i < wobsList.size(); ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)wobsList.elementAt(i);
                if (woData.getLockedStatus() != 1 || !woData.isDirty()) continue;
                return true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return false;
    }

    protected static boolean isAllWorkDirty(Vector wobsList) {
        try {
            for (int i = 0; i < wobsList.size(); ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)wobsList.elementAt(i);
                if (woData.isDirty()) continue;
                return false;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return true;
    }

    protected static boolean isAllLockedByCurrentUser(Vector wobsList) {
        try {
            for (int i = 0; i < wobsList.size(); ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)wobsList.elementAt(i);
                if (woData.getLockedStatus() == 1) continue;
                return false;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return true;
    }

    protected static void addChildrenToWobsList(Vector v_children, boolean bLockCondition, Vector wobsList) {
        try {
            if (v_children.size() == 0) {
                return;
            }
            for (int i = 0; i < v_children.size(); ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)v_children.elementAt(i);
                if (bLockCondition) {
                    if (woData.getLockedStatus() != 1) continue;
                    wobsList.addElement(woData);
                    continue;
                }
                wobsList.addElement(woData);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected static boolean isInDelayQueue(VWWorkObject wob) {
        try {
            if (wob != null) {
                String queueName = wob.getCurrentQueueName();
                if (queueName.length() > 5) {
                    queueName = queueName.substring(0, 5);
                }
                if ((queueName = queueName.toLowerCase(Locale.ENGLISH)).length() == 5 && VWStringUtils.compare(queueName, "delay") == 0) {
                    return true;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return false;
    }
}

